//
//  MCPGDatabase+Replication.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-03-08.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCPostgresPersistence/MCPGDatabase.h>

#import <MCClientServer/MCClientServerDefines.h>

// These must be defined on a per-application basis
@interface MCPGDatabase (MCSSubclassEnvironment)

- (BOOL)checkInReplicantLicenseForClientUUID: (NSString *)clientUUID forType:(MCSReplicaType)type error: (NSError **)error;

- (NSNumber*)userIDForUserNamed:(NSString *)username;

- (BOOL)userIsRestrictedForOffline:(NSString *)username error:(NSError **)error;
- (BOOL)userIsRestrictedForTouch:(NSString *)username error:(NSError **)error;

- (BOOL)restrictUser:(NSString *)username forOfflineError:(NSError **)error;
- (BOOL)restrictUser:(NSString *)username forTouchError:(NSError **)error;

- (BOOL)permitUser:(NSString *)username forOfflineError:(NSError **)error;
- (BOOL)permitUser:(NSString *)username forTouchError:(NSError **)error;

@end


@interface MCPGDatabase (MCSReplication)

- (BOOL)isHostedDatabase;
- (NSMutableDictionary*)replicantRowForUserID:(NSNumber*)userID clientUUID:(NSString *)clientUUID replicantType:(MCSReplicaType)aType error:(NSError **)error_p;
- (NSNumber *)loadReplicationOffsetForUserID:(NSNumber *)userID clientUUID:(NSString *)clientUUID replicantType:(MCSReplicaType)aType error:(NSError **)error_p;
- (MCSReplicaStatus)replicantStatusForType:(MCSReplicaType)type userName:(NSString *)username clientUUID:(NSString *)clientUUID error:(NSError **)error;
- (BOOL)setReplicantStatus:(MCSReplicaStatus)status forType:(MCSReplicaType)type userName:(NSString *)username clientUUID:(NSString *)clientUUID error:(NSError **)error;

@end


@interface MCPGDatabase (MCSOfflineReplicaStatusUpdating)

- (MCSReplicaStatus)offlineClientStatusForUserName:(NSString *)username clientUUID:(NSString *)clientUUID error:(NSError **)error;
- (BOOL)setOfflineClientStatus:(MCSReplicaStatus)status forUserName:(NSString *)username clientUUID:(NSString *)clientUUID error:(NSError **)error;
- (BOOL)deactivateOfflineClientForUserName:(NSString *)username clientUUID:(NSString *)clientUUID error:(NSError **)error;

@end


@interface MCPGDatabase (MCSTouchReplicaStatusUpdating)

- (MCSReplicaStatus)touchClientStatusForUserName:(NSString *)username clientUUID:(NSString *)clientUUID error:(NSError **)error;
- (BOOL)setTouchClientStatus:(MCSReplicaStatus)status forUserName:(NSString *)username clientUUID:(NSString *)clientUUID error:(NSError **)error;
- (BOOL)deactivateTouchClientForUserName:(NSString *)username clientUUID:(NSString *)clientUUID error:(NSError **)error;

@end
